/* 
	install "npm install socket.io@2.4.1"
	run "node server.js"
*/
var io = require('socket.io-client');

// Enter your API KEY here,
var api_key 			= 'API_KEY'; // get from https://fcsapi.com/dashboard

/*
	With Demo API_KEY only EUR/USD, XAU/USD, BTC,LTC prices are available, 
	If you need more prices, then please enter your API KEY, Signup to get your API KEY.
	
	EXCEL LIST:  https://fcsapi.com/beta/assets/socket/socket_support_list.xlsx
		Enter your Forex/Crypto ids, set multiple ids with comma
*/
var currency_ids 	= '1,1984,80,81,7774,7778';


// socket connection start first time
// setTimeout run code after 1 second so we make sure all library are loaded and ready to run 
setTimeout(function(){
	socket_connection();
},1500);

// Variables
var socket_re_conn,socket,heart_interval;

// wss:// if your application does not support WSS/SSL/HTTPS then use "ws://fcsapi.com" (http)
var main_url 		= 'wss://fcsapi.com'; // web socket URL
var backup_url		= 'wss://fxcoinapi.com'; // web socket backup URL
var ws_url 			= main_url; // Web Socket

// Use backup server incase our main server is not accessible
// Note: Only use it for backup.
function backup_server(){
	ws_url = backup_url; // backup URL
	socket_connection();

	// keep try to connect with main server after 10 minute.
	// To test if backup is working for you or not, just use wrong URL in main WebSocket URL
	setTimeout(function(){
		ws_url = main_url;
		socket_connection();
	},10*60*1000); // minute * seconds * 1000
}



// start socket connection function
function socket_connection(){
	// is_connect_to_backup();

	// if connection recall, then destroy old if exist. 
	if(socket !== undefined){
		socket.disconnect();
		socket.destroy();
	}

	// require connect with server
	socket = io.connect(ws_url,{
	    transports: ['websocket'],
		path : "/v3/"
	});

	// comment
	console.log("Connection Request send. Waiting response");

	// socket heartbeat require once every hour, if your heartbeat stop so you will disconnect
	socket.emit('heartbeat', api_key);
	
	// connect your required IDs with server
	socket.emit('real_time_join', currency_ids);

	// PRICES Real time data received  from server
	socket.on('data_received',function(prices_data){
		// console.log(prices_data); // see full response
		
		// get prices
		console.log(" -------------- NEW ------------ "+prices_data.s);
		var temp = {};
		temp['Id']  			= prices_data.id;
		temp['Currency']  = prices_data.s; // Name, EUR/USD
		temp['Decimal']  	= prices_data.dp; // No of decimal in currency
		temp['Ask']  			= prices_data.a; // Ask price
		temp['Bid']  			= prices_data.b;
		temp['Open']  		= prices_data.lc; //Open price
		temp['High']  		= prices_data.h;
		temp['Low']  			= prices_data.l;
		temp['Close']  		= prices_data.c; // current or close price
		temp['Spread']  	= prices_data.sp;
		temp['Change']  	= prices_data.ch;
		temp['Chg_per']  	= prices_data.cp; // change percentage
		
		if(typeof prices_data.v === 'undefined')
			temp['Volume']  = 0;
		else
			temp['Volume']  = prices_data.v;

		temp['Time']  = prices_data.t;

		console.log(temp);

	});

	// real time join on successfully message return
	socket.on('successfully',(message)=>{
		is_connect_to_backup();

		console.log(message);
		console.log("Connect with URL "+ws_url);
		// auto re-connection destroy, when we connect with server
		if(socket_re_conn !== undefined)
			clearTimeout(socket_re_conn);
	});

	// disconnect with message return
	socket.on('disconnect',(message)=>{
		console.log(message);

		// when you'r disconnect,  auto re-connection after 15 minute 
		socket_re_connection();
	});

	// disconnect with message return
	socket.on('message',(message)=>{
		console.log(message);
	});

	// if connection error then connect with backup.
	socket.on('connect_error', function(){
		// On error, socket will auto retry to connect, so we will wait 10 seconds before manully connect with backup
		
		try_backup  = setTimeout(backup_server,10000); // conenct with backup server

		console.log('Connection error. If you see this message for more then 15 minutes then contact us. ');
	});

	// heartbeat every hour 
	/* 
		You need to connect with server once per 24 hour, else your connection will be disconnect.
		Below we set heartbeat every hour, you can increase time upto 24 hours, 
		but do not decrease this time, beucase it will slow down your speed with server
	*/
	if(heart_interval !== undefined)
		clearTimeout(heart_interval);

	heart_interval = setInterval(function(){
		socket.emit('heartbeat', api_key);
	}, (1*60*60*1000)); // hour * minutes*seconds*1000; 

}



/* Reconnect if socket disconnect. 
	
	Note: You don't need to decrease re-connect time in setTimeout.
		in case of any socket failure, Socket has its own auto reconnect functionality, so it will quick reconnect with server.
		Below function is extra security, if socket auto reconnect fail, then this function will do its work.
*/
function socket_re_connection(){
	if(socket_re_conn !== undefined)
		clearTimeout(socket_re_conn);

	// keep trying reconnect until connect successfully
	// reconnect after every 15 minute
	socket_re_conn = setTimeout(function(){
		socket_connection();
		socket_re_connection();
	}, (15*60*1000));  // minute * seconds * 1000
}


/* Call this Function when you want to disconnect */
function disconnect() {
	if(socket !== undefined && !socket.disconnected){
		socket.disconnect();
		socket.destroy();
	}
	else{
		console.log( "You are not connected with Server");
	}
}


/*
	Clear old pending function, if server connection start auto/manuall
*/
var try_backup;
function is_connect_to_backup(){
	if(try_backup !== undefined)
		clearTimeout(try_backup);
}
